%%Emily R Barker
%%University of Southampton - QuantMig Research Fellow
%%E.R.Barker@soton.ac.uk
%%Do not use without author's permission
%%If you spot an error, or have any questions, please contact E Barker
%%Barker, E. R. (2021), The decline of East to West European Migration through automation, Working Papers forthcoming, MPRA.
%%Part of Barker E. R. and Bijak J (2021) Uncertainty in Migration Scenarios. QuantMig Project Deliverable D9.2 Data Description. Southampton: University of Southampton. 

var 
    %% firms
        y_t k_t lbraggl_t lbraggh_t x_t  %rhok_t q_t
	%% household
        hh_t ch_t wh_t 
        wm_t cm_t hm_t
	%% misc
        b_t r_t rer_t ph_t %t_t
    %% aggregate
        c_t z_t 
    %% fiscal
        bg_t taxwh_t taxwm_t taxw_t taxc_t taxf_t gc_t tax_t ge_t surp_t 
    %% shocks
        a_t m_t yf_t psix_t psiz_t psigc_t  psixz_t betta % psi_t
    %% observables
       % dy dx dc dz dnm dyf dgc

    %%Population dynamics
    g_t varphih_t varphim_t
    %% SMF

partich_t unemph_t Uh_t Nh_t uh_t nh_t mh_t vh_t oomegah_t upsilonh_t thetah_t lh_t Lambdah_t mplh_t muh_t lbrh_t
particm_t unempm_t Um_t Nm_t um_t nm_t mm_t vm_t oomegam_t upsilonm_t thetam_t lm_t Lambdam_t mplm_t mum_t lbrm_t

%3rd household
particl_t unempl_t Ul_t Nl_t ul_t nl_t ml_t vl_t oomegal_t upsilonl_t thetal_t ll_t Lambdal_t mpll_t mul_t wl_t cl_t hl_t %grl_t
taxwl_t varphil_t lbrl_t

particmh_t unempmh_t Umh_t Nmh_t umh_t nmh_t mmh_t vmh_t oomegamh_t upsilonmh_t thetamh_t lmh_t Lambdamh_t mplmh_t mumh_t wmh_t cmh_t hmh_t grmh_t
taxwmh_t varphimh_t lbrmh_t

xm_t km_t 
kh_t xh_t

X_t 

%%Robots
mpz_t
Z_t xz_t %qz_t 
bp_t
V_t mpkh_t mpkm_t 

bm_t bh_t
gdp_t tb_t

iotax_t iotax_diffcont_t iotax_difflag_t tq_t 

iotaxm_t iotaxm_diffcont_t iotaxm_difflag_t tqm_t

iotaxz_t iotaxz_diffcont_t iotaxz_difflag_t tqz_t

whwl_t
whwmh_t
wlwm_t
wmhwml_t

NHNT_t
NLNT_t
NMNT_t
NMHNT_t

lbrinch_t
lbrincl_t
lbrincm_t
lbrincmh_t


;

varexo ea em eyf epsi ex ez egc emh exz ebp; %ev egc epsih   ez_ME

parameters 

rhozm
bettap 
rhoa thetap rhom rhoyf deltta ces ac bhc etap etalp kappac gammap rhopsi rhopsix rhoxg rhoz rhogc tauw_ss tauc_ss tauf_ss
n_ss mpk_ss k_ss y_ss x_ss xg_ss ge_ss covery xovery geovery gcoverge gxoverge zoverge
cgovery xgovery zovery gc_ss z_ss hh_ss hm_ss wh_ss wm_ss taxf_ss taxc_ss
taxw_ss tax_ss zetabz zetayz rhogcv zetabgc zetaygc c_ss ch_ss cm_ss %phiz phigc

kappah rhopsih rhogxv zetabgx zetaygx % phigx

partich_ss  unemph_ss Uh_ss Nh_ss uh_ss nh_ss mh_ss vh_ss oomegah_ss upsilonh_ss thetah_ss lh_ss varphih_ss Lambdah_ss ubh 
particm_ss unempm_ss Um_ss Nm_ss um_ss nm_ss mm_ss vm_ss oomegam_ss upsilonm_ss thetam_ss lm_ss varphim_ss Lambdam_ss ubm
zeta Phih Phim muh_ss mum_ss mplh_ss mplm_ss

ah am rhonh rhonm Gammahp Gammamp kappavh kappavm varthetah varthetam rhovarphi
al rhonl Gammalp kappavl varthetal mpll_ss Phil mul_ss
amh rhonmh Gammamhp kappavmh varthetamh mplmh_ss Phimh ubmh
particl_ss unempl_ss Ul_ss Nl_ss ul_ss nl_ss ml_ss vl_ss oomegal_ss upsilonl_ss thetal_ss ll_ss varphil_ss Lambdal_ss ubl

wl_ss hl_ss cl_ss
taxwh_ss taxwm_ss taxwl_ss
lbrh_ss lbrm_ss lbrl_ss
sigmaea sigmaem sigmaeyf sigmaepsi sigmaepsih sigmaex sigmaegc sigmaexg sigmaez_ME sigmaez

alephh alephl alephm

zetap Ap X_ss 

a_ss

particmh_ss unempmh_ss Umh_ss Nmh_ss umh_ss nmh_ss mmh_ss vmh_ss oomegamh_ss upsilonmh_ss thetamh_ss lmh_ss Lambdamh_ss mumh_ss wmh_ss cmh_ss hmh_ss
taxwmh_ss varphimh_ss lbrmh_ss xm_ss km_ss kh_ss xh_ss

lbraggl_ss lbraggh_ss

Z_ss xz_ss tqz_ss V_ss mpz_ss ep delttaz bp mpkh_ss mpkm_ss 
    
r_ss

phik phiz 

sigp
epsp
rhop

Sigp 
Rhop 
alphap 

Thelbp
thelbp
b_ss
gdp_ss 
thetastarp
rstar_ss
bg_ss
yf_ss
ex_ss
vp
vstarp 
m_ss
phi0mhp
phi0mp
phi0hp
phi0lp
sigmap
sigmalp
KapKP
delkh

sigmaemh
sigmaexz
rhopsixz
kappaxp
phixp
rhobp
sigmaebp
g_ss

iotax_ss 
iotax_diffcont_ss 
iotax_difflag_ss 
iotaxm_ss 
iotaxm_diffcont_ss 
iotaxm_difflag_ss  
iotaxz_ss 
iotaxz_diffcont_ss 
iotaxz_difflag_ss 
;

sigmaea	=	1	;
sigmaem	=	1;%0.1708	;
sigmaeyf	=	0.1716	;
sigmaepsi	=	0.2852	;
sigmaepsih	=	0.5452	;
sigmaex	=	1;%0.4476	;
sigmaexz	=	1;%0.4476	;
sigmaegc	=	0.2544	;
sigmaez_ME	=	0.1255	;
sigmaez	=	0.1931	;
sigmaemh = 1;%0.1716 ;
sigmaebp = sigmaea ;


%%%%MONTHLY
sigmaea	=	0.2610	;
sigmaex	=	0.9953	;
sigmaepsi	=	0.2448	;
sigmaez	=	0.3894	;
sigmaeyf	=	0.2328	;
sigmaem	=	0.2433	;
sigmaegc	=	0.2322	;
sigmaez_ME	=	sigmaez	;
			
%sigmaepsih  =   0.5452  ;			
sigmaexz	=	sigmaex	;
sigmaemh	=	sigmaem	;
sigmaebp = sigmaea ;			

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
model; 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



m_t = rhom*m_t(-1) + sigmaem*em ;%+ sigmaem*emh ;
grmh_t =rhom*grmh_t(-1) + sigmaem*emh;% + sigmaem*em ;
%g_t = exp(varphimh_t)*(grmh_t) + exp(varphim_t)*(m_t) ;
g_t = varphimh_ss*(grmh_t) + varphim_ss*(m_t) ;
%psi_t = rhopsi*psi_t(-1) + sigmaepsi*epsi ;
betta = rhopsi*betta(-1) + (1-rhopsi)*bettap+ sigmaepsi*epsi ;


exp(varphih_t) = varphih_ss^(1-rhovarphi) * (g_ss/exp(g_t))*exp(varphih_t(-1))^rhovarphi ;% rhovarphi*exp(varphih_t(-1))*/exp(g_t) + (1-rhovarphi)*varphih_ss ;
exp(varphim_t) = varphim_ss^(1-rhovarphi) * (exp(m_t)/exp(g_t))*exp(varphim_t(-1))^rhovarphi ;%rhovarphi*exp(varphim_t(-1))/exp(g_t) + (1-rhovarphi)*varphim_ss ;
exp(varphil_t) = varphil_ss^(1-rhovarphi) * (g_ss/exp(g_t))*exp(varphil_t(-1))^rhovarphi ;%rhovarphi*exp(varphil_t(-1))/exp(g_t) + (1-rhovarphi)*varphil_ss ;
exp(varphimh_t) = varphimh_ss^(1-rhovarphi) * (exp(grmh_t)/exp(g_t))*exp(varphimh_t(-1))^rhovarphi ;%rhovarphi*exp(varphimh_t(-1))/exp(g_t) + (1-rhovarphi)*varphimh_ss ;

%%Natives

(exp(ch_t) - kappac*exp(ch_t(-1)))^(-sigmap) = exp(muh_t)*(1+(tauc_ss)) ;
phi0hp*(exp(hh_t) - kappah*exp(hh_t(-1)))^etap = exp(muh_t)*exp(wh_t)*exp(nh_t)*(1-tauw_ss) ; 
1/(1+r_t)         = betta*(exp(muh_t(+1)))/(exp(muh_t))*(exp(rer_t(+1)))/(exp(rer_t)) ;
exp(Lambdah_t)*exp(oomegah_t) = Phih*exp(lh_t)^(-zeta) - ubh*exp(muh_t) ;
exp(Lambdah_t) = -phi0hp/(1+etap)*(exp(hh_t))^(1+etap) + betta*(exp(muh_t(+1))*exp(wh_t(+1))*exp(hh_t(+1))*(1-tauw_ss) + (1-rhonh)*exp(Lambdah_t(+1)) - Phih*exp(lh_t)^(-zeta)) ;


%%High-Skill Migrants
(1+tauc_ss)*exp(mumh_t) = (exp(cmh_t) - kappac*exp(cmh_t(-1)))^(-sigmap) ;
phi0mhp*(exp(hmh_t) - kappah*exp(hmh_t(-1)))^etap = exp(mumh_t)*exp(wmh_t)*exp(nmh_t)*(1-tauw_ss) ; 
%1/(1+r_t)         = (betta*(exp(mumh_t(+1)))/(exp(mumh_t))*(exp(rer_t(+1)))/(exp(rer_t))*(1/(exp(grmh_t(+1))))) ;

exp(mumh_t)*exp(rer_t)*(1 + bhc*(bm_t -b_ss)) = betta*exp(mumh_t(+1))*exp(rer_t)*(1+r_t) ;


exp(Lambdamh_t)*exp(oomegamh_t) = Phimh*exp(lmh_t)^(-zeta) - ubmh*exp(mumh_t) ;
exp(Lambdamh_t) = -phi0mhp/(1+etap)*(exp(hmh_t))^(1+etap)+  betta*(exp(mumh_t(+1))*exp(wmh_t(+1))*exp(hmh_t(+1))*(1-tauw_ss) + (1-rhonmh)*exp(Lambdamh_t(+1)) - Phimh*exp(lmh_t)^(-zeta)) ;

%%SHOULD THIS BE KM_T(-1)??????
(1+tauc_ss)*exp(cmh_t) + exp(xm_t) = (1-tauw_ss)*(exp(wmh_t)*exp(hmh_t)*exp(nmh_t)) + exp(z_t) + ubmh*exp(umh_t) + exp(mpkm_t)*exp(km_t(-1)) + (bm_t(-1))*(1+r_t(-1))*exp(rer_t)/exp(grmh_t) - (bm_t)*exp(rer_t);

%%Low-Skill Migrants
exp(mum_t)*(1+tauc_ss) = (exp(cm_t) - kappac*exp(cm_t(-1)))^(-sigmalp) ;
phi0mp*(exp(hm_t) - kappah*exp(hm_t(-1)))^etap = exp(mum_t)*exp(wm_t)*exp(nm_t)*(1-tauw_ss) ; 
(1+tauc_ss)*exp(cm_t) = (1-tauw_ss)*exp(wm_t)*exp(hm_t)*exp(nm_t) + exp(z_t) + ubm*exp(um_t) ; 
exp(Lambdam_t)*exp(oomegam_t) = Phim*exp(lm_t)^(-zeta) - ubm*exp(mum_t) ;
exp(Lambdam_t) = -phi0mp/(1+etap)*(exp(hm_t))^(1+etap) +betta*(exp(mum_t(+1))*exp(wm_t(+1))*exp(hm_t(+1))*(1-tauw_ss) + (1-rhonm)*exp(Lambdam_t(+1)) - Phim*exp(lm_t)^(-zeta)) ;

%%%%Low-Skill Natives

(1+tauc_ss)*exp(mul_t) = (exp(cl_t) - kappac*exp(cl_t(-1)))^(-sigmalp) ;
phi0lp*(exp(hl_t) - kappah*exp(hl_t(-1)))^etap = exp(mul_t)*exp(wl_t)*exp(nl_t)*(1-tauw_ss) ; 
(1+tauc_ss)*exp(cl_t) = (1-tauw_ss)*exp(wl_t)*exp(hl_t)*exp(nl_t) + exp(z_t) + ubl*exp(ul_t) ; 
exp(Lambdal_t)*exp(oomegal_t) = Phil*exp(ll_t)^(-zeta) - ubl*exp(mul_t) ;
exp(Lambdal_t) = -phi0lp/(1+etap)*(exp(hl_t))^(1+etap) +betta*(exp(mul_t(+1))*exp(wl_t(+1))*exp(hl_t(+1))*(1-tauw_ss) + (1-rhonl)*exp(Lambdal_t(+1)) - Phil*exp(ll_t)^(-zeta)) ;



%%Firms
exp(bp_t) = rhobp*exp(bp_t(-1)) + (1-rhobp)*bp + sigmaebp*ebp  ;
exp(V_t) = (ep^(1/sigp)*exp(lbraggl_t)^Sigp + (1-ep)^(1/sigp)*(exp(bp_t)*exp(Z_t(-1)))^Sigp)^(1/Sigp) ;
exp(X_t) = (zetap^(1/rhop)*exp(k_t(-1))^Rhop + (1-zetap)^(1/rhop)*exp(lbraggh_t)^Rhop)^(1/Rhop) ;
exp(y_t) = exp(a_t)*(Ap^(1/epsp)*exp(V_t)^alphap + (1-Ap)^(1/epsp)*exp(X_t)^alphap)^(1/alphap) ;


exp(lbraggl_t) = ((alephl^(1/thelbp))*(exp(Nl_t)*exp(hl_t))^Thelbp + (alephm)^(1/thelbp)*(exp(Nm_t)*exp(hm_t))^Thelbp)^(1/Thelbp) ;
exp(lbraggh_t) = ((alephh^(1/thelbp))*(exp(Nh_t)*exp(hh_t))^Thelbp + (1-alephh)^(1/thelbp)*(exp(Nmh_t)*exp(hmh_t))^Thelbp)^(1/Thelbp) ;


%exp(rhok_t) = exp(ph_t)*(1-Ap)^(1/epsp)*zetap^(1/rhop)*exp(a_t)*(Ap^(1/epsp)*(exp(V_t)^(alphap)) + (1-Ap)^(1/epsp)*exp(X_t)^(alphap))^(1/alphap-1)*(zetap^(1/rhop)*exp(k_t(-1))^Rhop + (1-zetap)^(1/rhop)*exp(lbraggh_t)^Rhop)^(alphap/Rhop-1)*exp(k_t(-1))^(Rhop-1) ;

exp(mpz_t) = exp(ph_t)*Ap^(1/epsp)*(1-ep)^(1/sigp)*(exp(bp_t))^Sigp*exp(a_t)*(Ap^(1/epsp)*((ep^(1/sigp)*exp(lbraggl_t)^(Sigp) + (1-ep)^(1/sigp)*(exp(bp_t)*exp(Z_t(-1)))^Sigp)^(alphap/Sigp)) + (1-Ap)^(1/epsp)*((zetap^(1/rhop)*exp(k_t(-1))^Rhop + (1-zetap)^(1/rhop)*exp(lbraggh_t)^Rhop)^(alphap/Rhop)))^(1/alphap-1)*(ep^(1/sigp)*exp(lbraggl_t)^(Sigp) + (1-ep)^(1/sigp)*(exp(bp_t)*exp(Z_t(-1)))^Sigp)^(alphap/Sigp-1)*exp(Z_t(-1))^(Sigp-1) ;


exp(mplm_t) = exp(ph_t)*Ap^(1/epsp)*(ep)^(1/sigp)*(alephm)^(1/thelbp)*exp(a_t)*(Ap^(1/epsp)*((ep^(1/sigp)*exp(lbraggl_t)^(Sigp) + (1-ep)^(1/sigp)*(exp(bp_t)*exp(Z_t(-1)))^Sigp)^(alphap/Sigp)) + (1-Ap)^(1/epsp)*((zetap^(1/rhop)*exp(k_t(-1))^Rhop + (1-zetap)^(1/rhop)*exp(lbraggh_t)^Rhop)^(alphap/Rhop)))^(1/alphap-1)*(ep^(1/sigp)*exp(lbraggl_t)^(Sigp) + (1-ep)^(1/sigp)*(exp(bp_t)*exp(Z_t(-1)))^Sigp)^(alphap/Sigp-1)*((alephl^(1/thelbp))*(exp(Nl_t)*exp(hl_t))^Thelbp + (alephm)^(1/thelbp)*(exp(Nm_t)*exp(hm_t))^Thelbp)^(Sigp/Thelbp-1)*(exp(Nm_t)*exp(hm_t))^(Thelbp-1)  ;
exp(mpll_t) = exp(ph_t)*Ap^(1/epsp)*(ep)^(1/sigp)*(alephl)^(1/thelbp)*exp(a_t)*(Ap^(1/epsp)*((ep^(1/sigp)*exp(lbraggl_t)^(Sigp) + (1-ep)^(1/sigp)*(exp(bp_t)*exp(Z_t(-1)))^Sigp)^(alphap/Sigp)) + (1-Ap)^(1/epsp)*((zetap^(1/rhop)*exp(k_t(-1))^Rhop + (1-zetap)^(1/rhop)*exp(lbraggh_t)^Rhop)^(alphap/Rhop)))^(1/alphap-1)*(ep^(1/sigp)*exp(lbraggl_t)^(Sigp) + (1-ep)^(1/sigp)*(exp(bp_t)*exp(Z_t(-1)))^Sigp)^(alphap/Sigp-1)*((alephl^(1/thelbp))*(exp(Nl_t)*exp(hl_t))^Thelbp + (alephm)^(1/thelbp)*(exp(Nm_t)*exp(hm_t))^Thelbp)^(Sigp/Thelbp-1)*(exp(Nl_t)*exp(hl_t))^(Thelbp-1)  ;

exp(mplh_t) = exp(ph_t)*(1-Ap)^(1/epsp)*(1-zetap)^(1/rhop)*alephh^(1/thelbp)*exp(a_t)*(Ap^(1/epsp)*((ep^(1/sigp)*exp(lbraggl_t)^(Sigp) + (1-ep)^(1/sigp)*(exp(bp_t)*exp(Z_t(-1)))^Sigp)^(alphap/Sigp)) + (1-Ap)^(1/epsp)*((zetap^(1/rhop)*exp(k_t(-1))^Rhop + (1-zetap)^(1/rhop)*exp(lbraggh_t)^Rhop)^(alphap/Rhop)))^(1/alphap-1)*(zetap^(1/rhop)*exp(k_t(-1))^Rhop + (1-zetap)^(1/rhop)*exp(lbraggh_t)^Rhop)^(alphap/Rhop-1)*((alephh^(1/thelbp))*(exp(Nh_t)*exp(hh_t))^Thelbp + (1-alephh)^(1/thelbp)*(exp(Nmh_t)*exp(hmh_t))^Thelbp)^(Rhop/Thelbp-1)*(exp(Nh_t)*exp(hh_t))^(Thelbp-1) ;
exp(mplmh_t) = exp(ph_t)*(1-Ap)^(1/epsp)*(1-zetap)^(1/rhop)*(1-alephh)^(1/thelbp)*exp(a_t)*(Ap^(1/epsp)*((ep^(1/sigp)*exp(lbraggl_t)^(Sigp) + (1-ep)^(1/sigp)*(exp(bp_t)*exp(Z_t(-1)))^Sigp)^(alphap/Sigp)) + (1-Ap)^(1/epsp)*((zetap^(1/rhop)*exp(k_t(-1))^Rhop + (1-zetap)^(1/rhop)*exp(lbraggh_t)^Rhop)^(alphap/Rhop)))^(1/alphap-1)*(zetap^(1/rhop)*exp(k_t(-1))^Rhop + (1-zetap)^(1/rhop)*exp(lbraggh_t)^Rhop)^(alphap/Rhop-1)*((alephh^(1/thelbp))*(exp(Nh_t)*exp(hh_t))^Thelbp + (1-alephh)^(1/thelbp)*(exp(Nmh_t)*exp(hmh_t))^Thelbp)^(Rhop/Thelbp-1)*(exp(Nmh_t)*exp(hmh_t))^(Thelbp-1) ;

exp(a_t) = rhoa*exp(a_t(-1)) + (1-rhoa)*a_ss + sigmaea*ea ;
%exp(kh_t) = (1-deltta)*exp(kh_t(-1)) + (exp(xh_t)*exp(psix_t)) ;
%exp(km_t) = (1-deltta)*exp(km_t(-1)) + (exp(xm_t)) ;
%exp(kh_t) = (1-deltta)*exp(kh_t(-1)) + phik/2*(exp(kh_t)/exp(kh_t(-1)) - 1)^2*exp(kh_t) + exp(xh_t);
%exp(km_t) = (1-deltta)*exp(km_t(-1)) + phik/2*(exp(km_t)/exp(km_t(-1)) - 1)^2*exp(km_t) + exp(xm_t);


%exp(k_t) = exp(varphih_t)*exp(kh_t) + exp(varphimh_t)*exp(km_t) ;
%exp(x_t) = exp(varphih_t)*exp(xh_t) + exp(varphimh_t)*exp(xm_t) ;

exp(k_t) = (delkh*exp(kh_t)^(KapKP) + (1-delkh)*exp(km_t)^(KapKP))^(1/KapKP) ;
exp(x_t) = (delkh*exp(xh_t)^(KapKP) + (1-delkh)*exp(xm_t)^(KapKP))^(1/KapKP) ;


iotax_t           = kappaxp*exp(xh_t)*(1-(phixp)/(2)*((exp(xh_t))/(exp(xh_t(-1)))-1)^2)*exp(psix_t);
iotax_diffcont_t  = iotax_t/(exp(xh_t))-kappaxp*phixp*((exp(xh_t))/(exp(xh_t(-1)))-1)*(exp(xh_t))/(exp(xh_t(-1)));
iotax_difflag_t   = kappaxp*phixp*((exp(xh_t))/(exp(xh_t(-1)))-1)*((exp(xh_t))/(exp(xh_t(-1))))^2;

iotaxm_t           = kappaxp*exp(xm_t)*(1-(phixp)/(2)*((exp(xm_t))/(exp(xm_t(-1)))-1)^2)*exp(psix_t);
iotaxm_diffcont_t  = iotaxm_t/(exp(xm_t))-kappaxp*phixp*((exp(xm_t))/(exp(xm_t(-1)))-1)*(exp(xm_t))/(exp(xm_t(-1)));
iotaxm_difflag_t   = kappaxp*phixp*((exp(xm_t))/(exp(xm_t(-1)))-1)*((exp(xm_t))/(exp(xm_t(-1))))^2;

iotaxz_t           = kappaxp*exp(xz_t)*(1-(phixp)/(2)*((exp(xz_t))/(exp(xz_t(-1)))-1)^2)*exp(psixz_t);
iotaxz_diffcont_t  = iotaxz_t/(exp(xz_t))-kappaxp*phixp*((exp(xz_t))/(exp(xz_t(-1)))-1)*(exp(xz_t))/(exp(xz_t(-1)));
iotaxz_difflag_t   = kappaxp*phixp*((exp(xz_t))/(exp(xz_t(-1)))-1)*((exp(xz_t))/(exp(xz_t(-1))))^2;



exp(kh_t) = (1-deltta)*exp(kh_t(-1)) + iotax_t;
exp(km_t) = (1-deltta)*exp(km_t(-1)) + iotaxm_t;
exp(tq_t)        = (betta*(exp(muh_t(+1)))/(exp(muh_t))*(exp(mpkh_t(+1)) +(1-deltta)*exp(tq_t(+1))))  ;
1                = exp(tq_t)*iotax_diffcont_t + betta*((exp(muh_t(+1)))/(exp(muh_t))*exp(tq_t(+1))*iotax_difflag_t(+1));

exp(tqm_t)        = (betta*(exp(mumh_t(+1)))/(exp(mumh_t))*(exp(mpkm_t(+1)) +(1-deltta)*exp(tqm_t(+1))))  ;
1                = exp(tqm_t)*iotaxm_diffcont_t + betta*((exp(mumh_t(+1)))/(exp(mumh_t))*exp(tqm_t(+1))*iotaxm_difflag_t(+1));



%exp(muh_t) = betta*exp(muh_t(+1))*(exp(mpkh_t(+1)) + (1-deltta)) ; %Eq 47
%exp(muh_t)*(1+phik/2*(exp(kh_t)/exp(kh_t(-1))-1)) = betta*exp(muh_t(+1))*(exp(mpkh_t(+1)) + (1-deltta) + phik/2*(exp(kh_t(+1))/exp(kh_t) -1)) ;
%exp(mumh_t)*(1+phik/2*(exp(km_t)/exp(km_t(-1))-1)) = betta*exp(mumh_t(+1))*(exp(mpkm_t(+1)) + (1-deltta) + phik/2*(exp(km_t(+1))/exp(km_t) -1)) ;
%%From Ch2:
%exp(muh_t)*(1+phik*(exp(kh_t(+1))/exp(kh_t))) = betta*exp(muh_t(+1))*(exp(rhok_t(+1)) + (1-deltta) + phik/2*(exp(kh_t(+2))/exp(kh_t(+1)) -1)) ;
%exp(mumh_t)*(1+phik*(exp(kmh_t(+1))/exp(kmh_t))) = betta*exp(mumh_t(+1))*(exp(mpkh_t(+1)) + (1-deltta) + phik/2*(exp(kmh_t(+2))/exp(kmh_t(+1)) -1)) ;

%exp(mpkm_t) = exp(ph_t)*(1-Ap)^(1/epsp)*zetap^(1/rhop)*exp(a_t)*(Ap^(1/epsp)*(exp(V_t)^(alphap)) + (1-Ap)^(1/epsp)*exp(X_t)^(alphap))^(1/alphap-1)*(zetap^(1/rhop)*exp(k_t(-1))^Rhop + (1-zetap)^(1/rhop)*exp(lbraggh_t)^Rhop)^(alphap/Rhop-1)*exp(k_t(-1))^(Rhop-1) ;
%exp(mpkh_t) = exp(ph_t)*(1-Ap)^(1/epsp)*zetap^(1/rhop)*exp(a_t)*(Ap^(1/epsp)*(exp(V_t)^(alphap)) + (1-Ap)^(1/epsp)*exp(X_t)^(alphap))^(1/alphap-1)*(zetap^(1/rhop)*exp(k_t(-1))^Rhop + (1-zetap)^(1/rhop)*exp(lbraggh_t)^Rhop)^(alphap/Rhop-1)*exp(k_t(-1))^(Rhop-1) ;

exp(mpkh_t) = (1-Ap)^(1/epsp)*(zetap)^(1/rhop)*exp(a_t)*delkh*(Ap^(1/epsp)*exp(V_t)^(alphap) + (1-Ap)^(1/epsp)*exp(X_t)^(alphap))^(1/alphap-1)*(zetap^(1/rhop)*exp(k_t)^Rhop + (1-zetap)^(1/rhop)*exp(lbraggh_t)^Rhop)^(alphap/Rhop-1)*(delkh*(exp(kh_t(-1)))^(KapKP)+(1-delkh)*(exp(km_t(-1)))^(KapKP))^(Rhop/KapKP-1)*(exp(kh_t(-1)))^(KapKP-1)    ;
exp(mpkm_t) = (1-Ap)^(1/epsp)*(zetap)^(1/rhop)*exp(a_t)*(1-delkh)*(Ap^(1/epsp)*exp(V_t)^(alphap) + (1-Ap)^(1/epsp)*exp(X_t)^(alphap))^(1/alphap-1)*(zetap^(1/rhop)*exp(k_t)^Rhop + (1-zetap)^(1/rhop)*exp(lbraggh_t)^Rhop)^(alphap/Rhop-1)*(delkh*(exp(kh_t(-1)))^(KapKP)+(1-delkh)*(exp(km_t(-1)))^(KapKP))^(Rhop/KapKP-1)*(exp(km_t(-1)))^(KapKP-1)    ;


psix_t = rhopsix*psix_t(-1) + sigmaex*ex  ;
psixz_t = rhopsixz*psixz_t(-1) + sigmaexz*exz  ;



kappavh/exp(upsilonh_t) = betta*exp(muh_t(+1))/exp(muh_t)*(exp(mplh_t(+1)) - (1+tauf_ss)*exp(wh_t(+1)) + kappavh/exp(upsilonh_t(+1))*((1-rhonh))) ;
kappavm/exp(upsilonm_t) = betta*exp(muh_t(+1))/exp(muh_t)*(exp(mplm_t(+1)) - (1+tauf_ss)*exp(wm_t(+1)) + kappavm/exp(upsilonm_t(+1))*((1-rhonm))) ;
kappavl/exp(upsilonl_t) = betta*exp(muh_t(+1))/exp(muh_t)*(exp(mpll_t(+1)) - (1+tauf_ss)*exp(wl_t(+1)) + kappavl/exp(upsilonl_t(+1))*((1-rhonl))) ;
kappavmh/exp(upsilonmh_t) = betta*exp(muh_t(+1))/exp(muh_t)*(exp(mplmh_t(+1)) - (1+tauf_ss)*exp(wmh_t(+1)) + kappavmh/exp(upsilonmh_t(+1))*((1-rhonmh))) ;

exp(wh_t) = (1-varthetah)/(1+tauf_ss)*(exp(mplh_t) + (1-rhonh)*kappavh/exp(upsilonh_t)) + varthetah/(exp(muh_t)*(1-tauw_ss))*(Phih*(exp(lh_t)^(-zeta))- (1-rhonh)*exp(Lambdah_t)) ;
exp(wm_t) = (1-varthetam)/(1+tauf_ss)*(exp(mplm_t) + (1-rhonm)*kappavm/exp(upsilonm_t)) + varthetam/(exp(mum_t)*(1-tauw_ss))*(Phim*(exp(lm_t)^(-zeta))- (1-rhonm)*exp(Lambdam_t)) ;
exp(wl_t) = (1-varthetal)/(1+tauf_ss)*(exp(mpll_t) + (1-rhonl)*kappavl/exp(upsilonl_t)) + varthetal/(exp(mul_t)*(1-tauw_ss))*(Phil*(exp(ll_t)^(-zeta))- (1-rhonl)*exp(Lambdal_t)) ;
exp(wmh_t) = (1-varthetamh)/(1+tauf_ss)*(exp(mplmh_t) + (1-rhonmh)*kappavmh/exp(upsilonmh_t)) + varthetamh/(exp(mumh_t)*(1-tauw_ss))*(Phimh*(exp(lmh_t)^(-zeta))- (1-rhonmh)*exp(Lambdamh_t)) ;

%%%Robots
exp(Z_t) = (1-delttaz)*(exp(Z_t(-1)))/exp(g_t) + iotaxz_t;%+psix_t eq 60
exp(tqz_t)        = (betta*(exp(muh_t(+1)))/(exp(muh_t))*(exp(mpz_t(+1)) +(1-delttaz)*exp(tqz_t(+1))))  ;
1                = exp(tqz_t)*iotaxz_diffcont_t + betta*((exp(muh_t(+1)))/(exp(muh_t))*exp(tqz_t(+1))*iotaxz_difflag_t(+1));


%%Open Economy
%%GDP

vp*(exp(ph_t))^(1-thetap) = 1- (1-vp)*(exp(rer_t))^(1-thetap);
exp(y_t) = vp*((exp(ph_t))^(-thetap))*(exp(c_t) + exp(x_t) + exp(xz_t) + exp(gc_t) + exp(z_t) + kappavh*exp(vh_t) +  kappavmh*exp(vmh_t) + kappavm*exp(vm_t) + kappavl*exp(vl_t)) + vstarp*((exp(rer_t))/(exp(ph_t)))^(thetastarp)*exp(yf_t) ;
%%Market Clearing

yf_t = rhoyf*yf_t(-1) + eyf ;
(r_t)      = rstar_ss*exp(-bhc*(b_t-b_ss));
b_t          = ((r_t(-1)))*(exp(gdp_t(-1)))/(exp(gdp_t))*(exp(rer_t))/(exp(rer_t(-1)))*b_t(-1) + tb_t ;
tb_t         =  1 - (exp(c_t) + exp(x_t) + exp(xz_t) + exp(gc_t) + exp(z_t) + kappavh*exp(vh_t) +  kappavmh*exp(vmh_t) + kappavm*exp(vm_t) + kappavl*exp(vl_t))/exp(gdp_t) ;
exp(gdp_t) = exp(ph_t)*exp(y_t) ;
%%Aggregates

exp(c_t) = exp(varphih_t)*exp(ch_t) + exp(varphim_t)*exp(cm_t) + exp(varphimh_t)*exp(cmh_t) + exp(varphil_t)*(exp(cl_t)) ;
b_t = exp(varphih_t)*(bh_t) + exp(varphimh_t)*(bm_t) ;
%%Fiscal

exp(z_t) = rhozm*exp(z_t(-1)) + (1-rhozm)*z_ss - zetayz*(exp(y_t(-1))-y_ss) - zetabz*(bg_t(-1)-bg_ss)+ psiz_t ;
psiz_t = rhoz*psiz_t(-1) + sigmaez_ME*ez ;

exp(gc_t) = rhogcv*exp(gc_t(-1)) + (1-rhogcv)*gc_ss  - zetaygc*(exp(y_t(-1))-y_ss) - zetabgc*(bg_t(-1)-b_ss) + psigc_t ;
psigc_t = rhogc*psigc_t(-1) + sigmaegc*egc ;

exp(taxwh_t) = tauw_ss*(exp(wh_t)*exp(hh_t)*exp(nh_t));

exp(taxwmh_t) = tauw_ss*(exp(wmh_t)*exp(hmh_t)*exp(nmh_t));

exp(taxwl_t) = tauw_ss*(exp(wl_t)*exp(hl_t)*exp(nl_t));

exp(taxwm_t) = tauw_ss*(exp(wm_t)*exp(hm_t)*exp(nm_t));

exp(taxw_t) = exp(varphih_t)*exp(taxwh_t) + exp(varphimh_t)*exp(taxwmh_t) + exp(varphim_t)*exp(taxwm_t) + exp(varphil_t)*exp(taxwl_t) ;

exp(taxc_t) = tauc_ss*exp(c_t) ;

exp(taxf_t) = tauf_ss*( exp(wh_t)*exp(hh_t)*exp(Nh_t) + exp(wmh_t)*exp(hmh_t)*exp(Nmh_t) + exp(wl_t)*exp(hl_t)*exp(Nl_t) + exp(wm_t)*exp(hm_t)*exp(Nm_t)) ;

exp(tax_t) = exp(taxw_t) + exp(taxc_t) + exp(taxf_t) ; %%Eq 82

(surp_t) = (bg_t(-1)*(1+r_t)/exp(g_t)) - bg_t ; 

exp(ge_t) = exp(gc_t) + exp(z_t) ;

(surp_t) = exp(tax_t)- (exp(ge_t) + exp(Uh_t)*ubh + exp(Um_t)*ubm + exp(Ul_t)*ubl + exp(Umh_t)*ubmh ) ;

%%%%%%%%%%%%%%%%%%%
%%SMF
%%%%%%%%%%%%%%%%%%%

exp(partich_t) = (exp(Nh_t) +exp(Uh_t))/exp(varphih_t) ;
exp(particl_t) = (exp(Nl_t) + exp(Ul_t))/exp(varphil_t) ;
exp(particmh_t) = (exp(Nmh_t) + exp(Umh_t))/exp(varphimh_t) ;
exp(particm_t) = (exp(Nm_t) + exp(Um_t))/exp(varphim_t) ;


exp(unemph_t) = exp(Uh_t)/(exp(Nh_t) + exp(Uh_t)) ;
exp(unempl_t) = exp(Ul_t)/(exp(Nl_t) + exp(Ul_t)) ;
exp(unempmh_t) = exp(Umh_t)/(exp(Nmh_t)+ exp(Umh_t)) ;
exp(unempm_t) = exp(Um_t)/(exp(Nm_t)+ exp(Um_t)) ;


exp(Nh_t) = (1-rhonh)*exp(Nh_t(-1)) + exp(mh_t)  + g_t*(varphih_ss)*exp(partich_t)*(1-exp(unemph_t));
exp(Nl_t) = (1-rhonl)*exp(Nl_t(-1)) + exp(ml_t) + g_t*(varphil_ss)*exp(particl_t)*(1-exp(unempl_t));
exp(Nm_t) = (1-rhonm)*exp(Nm_t(-1)) + exp(mm_t)  + g_t*(varphim_ss)*exp(particm_t)*(1-exp(unempm_t));
exp(Nmh_t) = (1-rhonmh)*exp(Nmh_t(-1)) + exp(mmh_t)  + g_t*(varphimh_ss)*exp(particmh_t)*(1-exp(unempmh_t)) ;

%exp(Nh_t) = (1-rhonh)*exp(Nh_t(-1)) + exp(mh_t)  + (grmh_t+m_t)*(varphih_ss)*(partich_ss)*(1-(unemph_ss));
%exp(Nl_t) = (1-rhonl)*exp(Nl_t(-1)) + exp(ml_t) + (grmh_t+m_t)*(varphil_ss)*(particl_ss)*(1-(unempl_ss));
%exp(Nm_t) = (1-rhonm)*exp(Nm_t(-1)) + exp(mm_t)  + (grmh_t+m_t)*(varphim_ss)*(particm_ss)*(1-(unempm_ss));
%exp(Nmh_t) = (1-rhonmh)*exp(Nmh_t(-1)) + exp(mmh_t)  + (grmh_t+m_t)*(varphimh_ss)*(particmh_ss)*(1-(unempmh_ss));


exp(Nh_t) = exp(varphih_t)*exp(nh_t) ;
exp(Nl_t) = exp(varphil_t)*exp(nl_t) ;
exp(Nm_t) = exp(varphim_t)*exp(nm_t) ;
exp(Nmh_t) = exp(varphimh_t)*exp(nmh_t) ;

exp(Uh_t) = exp(varphih_t)*exp(uh_t)  + (varphih_ss)*exp(partich_t)*exp(unemph_t)*(g_t) ;
exp(Ul_t) = exp(varphil_t)*exp(ul_t)  + (varphil_ss)*exp(particl_t)*exp(unempl_t)*(g_t) ;
exp(Umh_t)= exp(varphimh_t)*exp(umh_t)  + (varphimh_ss)*exp(particmh_t)*exp(unempmh_t)*(g_t) ;
exp(Um_t) = exp(varphim_t)*exp(um_t) + (varphim_ss)*exp(particm_t)*exp(unempm_t)*(g_t) ;

%exp(Uh_t) = exp(varphih_t)*exp(uh_t)  + (varphih_ss)*(partich_ss)*(unemph_ss)*(g_t) ;
%exp(Ul_t) = exp(varphil_t)*exp(ul_t)  + (varphil_ss)*(particl_ss)*(unempl_ss)*(g_t) ;
%exp(Umh_t)= exp(varphimh_t)*exp(umh_t)  + (varphimh_ss)*(particmh_ss)*(unempmh_ss)*(g_t) ;
%exp(Um_t) = exp(varphim_t)*exp(um_t) + (varphim_ss)*(particm_ss)*(unempm_ss)*(g_t) ;

%exp(Uh_t) = exp(varphih_t)*exp(uh_t)  + (grmh_t+m_t)*(varphih_ss)*(partich_ss)*(unemph_ss);
%exp(Ul_t) = exp(varphil_t)*exp(ul_t)  + (grmh_t+m_t)*(varphil_ss)*(particl_ss)*((unempl_ss)) ;
%exp(Umh_t)= exp(varphimh_t)*exp(umh_t)  +  (grmh_t+m_t)*(varphim_ss)*(particm_ss)*((unempm_ss));
%exp(Um_t) = exp(varphim_t)*exp(um_t) + (grmh_t+m_t)*(varphimh_ss)*(particmh_ss)*((unempmh_ss)) ;


exp(mh_t) = ah*((exp(vh_t))^Gammahp)*((exp(Uh_t))^(1-Gammahp)) ;
exp(ml_t) = al*((exp(vl_t))^Gammahp)*((exp(Ul_t))^(1-Gammahp)) ;
exp(mm_t) = am*((exp(vm_t))^Gammahp)*((exp(Um_t))^(1-Gammahp)) ;
exp(mmh_t) = amh*((exp(vmh_t))^Gammahp)*((exp(Umh_t))^(1-Gammahp)) ;


exp(oomegah_t) = exp(mh_t)/exp(Uh_t) ;
exp(oomegam_t) = exp(mm_t)/exp(Um_t) ;
exp(oomegal_t) = exp(ml_t)/exp(Ul_t) ;
exp(oomegamh_t) = exp(mmh_t)/exp(Umh_t) ;

exp(upsilonh_t) = exp(mh_t)/exp(vh_t) ;
exp(upsilonm_t) = exp(mm_t)/exp(vm_t) ;
exp(upsilonl_t) = exp(ml_t)/exp(vl_t) ;
exp(upsilonmh_t) = exp(mmh_t)/exp(vmh_t) ;

exp(thetah_t) = exp(vh_t)/exp(Uh_t) ;
exp(thetam_t) = exp(vm_t)/exp(Um_t) ;
exp(thetal_t) = exp(vl_t)/exp(Ul_t) ;
exp(thetamh_t) = exp(vmh_t)/exp(Umh_t) ;

1 = exp(nh_t) + exp(uh_t) + exp(lh_t) ;
1 = exp(nm_t) + exp(um_t) +exp(lm_t) ;
1 = exp(nl_t) + exp(ul_t) + exp(ll_t) ;
1 = exp(nmh_t) + exp(umh_t) + exp(lmh_t)  ;

exp(lbrh_t) = exp(Nh_t)*exp(hh_t) ;
exp(lbrm_t) = exp(Nm_t)*exp(hm_t) ;
exp(lbrl_t) = exp(Nl_t)*exp(hl_t) ;
exp(lbrmh_t) = exp(Nmh_t)*exp(hmh_t) ;

exp(whwl_t) = exp(wh_t)/exp(wl_t) ;
exp(whwmh_t) = exp(wh_t)/exp(wmh_t) ;
exp(wlwm_t) = exp(wl_t)/exp(wm_t) ;
exp(wmhwml_t) = exp(wmh_t)/exp(wm_t) ;

exp(NHNT_t) = exp(Nh_t)/(exp(Nh_t)+exp(Nm_t)+exp(Nmh_t)+exp(Nl_t)) ;
exp(NLNT_t) = exp(Nl_t)/(exp(Nh_t)+exp(Nm_t)+exp(Nmh_t)+exp(Nl_t)) ;
exp(NMNT_t) = exp(Nm_t)/(exp(Nh_t)+exp(Nm_t)+exp(Nmh_t)+exp(Nl_t)) ;
exp(NMHNT_t) = exp(Nmh_t)/(exp(Nh_t)+exp(Nm_t)+exp(Nmh_t)+exp(Nl_t)) ;

exp(lbrinch_t)= exp(wh_t)*exp(hh_t)*exp(nh_t) ;
exp(lbrincl_t)= exp(wl_t)*exp(hl_t)*exp(nl_t) ;
exp(lbrincm_t) = exp(wm_t)*exp(hm_t)*exp(nm_t) ;
exp(lbrincmh_t) = exp(wmh_t)*exp(hmh_t)*exp(nmh_t) ;

end;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%steady_state_model;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

shocks;

	var		ea      ;	stderr		sigmaea		;
	var		em      ;	stderr		sigmaem		;
	var		eyf     ;	stderr		sigmaeyf		;
	var		epsi	;	stderr		sigmaepsi		;
	var		ex      ;	stderr		sigmaex		;
	var		exz      ;	stderr		sigmaexz		;
	var		egc     ;	stderr		sigmaegc		;
	%var		ez_ME	;	stderr		sigmaez_ME		;
	var		ez      ;	stderr		sigmaez		;
    var		emh      ;	stderr		sigmaemh		; 
	var		ebp      ;	stderr		sigmaebp		;

end;

//check the starting values for the steady state
resid;

// compute steady state given the starting values
steady;
// check Blanchard-Kahn-conditions
check;

//simulate data for estimation
stoch_simul(order=1,irf=20,nograph )%irf_shocks =(ea)


;
